% Solve the cAMP Model

% Rate constants from Paper
%k=[1.4 0.9 2.5 1.5 0.6 0.8 2.0 1.3 0.7 1.0 0.3 3.1 1.8 1.5];
k=[1.4 0.9 2.5 1.5 0.6 0.8 2.0 1.3 0.7 1.0 0.3 0.1 1.8 1.5];
conc=[1.4 1.0 1.65 2.45 1.0 0.1 1.5];
options = odeset('RelTol',1e-3, 'AbsTol',1e-6);

[t,y]=ode15s(@camp_oscillation,[0 60],conc,options,k);

pACA=y(:,1); pPKA=y(:,2); pERK2=y(:,3); pREGA=y(:,4);
picAMP=y(:,5); pecAMP=y(:,6); pCAR=y(:,7);

subplot(2,1,1);
plot(t,pACA,'-ob',t,pREGA,'-og',t,picAMP,'-or',t,pecAMP,'-oc');
legend('ACA','REGA','icAMP','ecAMP');
subplot(2,1,2);
plot(t,pPKA,'-og',t,pERK2,'-or',t,pCAR,'-ob');
legend('PKA','ERK2','CAR');