% cAMP Oscillation model

function dydt = camp_oscillation(t,y,k)

dydt = zeros(7,1);    % a column vector
ACA=y(1); PKA=y(2); ERK2=y(3); REGA=y(4);
icAMP=y(5); ecAMP=y(6); CAR=y(7);


dACA   = k(1)*ERK2   - k(2)*ACA;
dPKA   = k(3)*icAMP  - k(4)*PKA;
dERK2  = k(5)*CAR    - k(6)*ERK2*PKA;
dREGA  = k(7)        - k(8)*REGA*ERK2;
dicAMP = k(9)*ACA    - k(10)*REGA*icAMP;
decAMP = k(11)*ACA   - k(12)*ecAMP;
dCAR   = k(13)*ecAMP - k(14)*CAR*PKA;

dydt(1) = dACA;
dydt(2) = dPKA;
dydt(3) = dERK2;
dydt(4) = dREGA;
dydt(5) = dicAMP;
dydt(6) = decAMP;
dydt(7) = dCAR;

end;