(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13582,        347]
NotebookOptionsPosition[     12167,        315]
NotebookOutlinePosition[     12559,        331]
CellTagsIndexPosition[     12516,        328]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Vector Plot for Vortices", "Title",
 CellChangeTimes->{{3.910676345299337*^9, 
  3.910676358397435*^9}},ExpressionUUID->"0ee00e5c-acc3-4005-a4b9-\
7f49da2e93ca"],

Cell["PhiHat is the normalized Phi:", "Text",
 CellChangeTimes->{{3.910676414739709*^9, 
  3.910676433097027*^9}},ExpressionUUID->"b12e6d83-ad70-4e3d-80a7-\
fe9588d48d2d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PhiHat", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{
         RowBox[{"PhiHat", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", "\[Alpha]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{
         RowBox[{"PhiHat", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", "\[Alpha]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", 
     RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9106763660133343`*^9, 3.91067640608105*^9}, {
  3.9106772979986467`*^9, 3.9106772982429667`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"0fd0da47-f127-4a09-8311-f2e2b20b47eb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Alpha]$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Alpha]$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> VectorPlot[{
         Re[$CellContext`PhiHat[$CellContext`x, $CellContext`y] 
          Exp[I $CellContext`\[Alpha]$$]], 
         Im[$CellContext`PhiHat[$CellContext`x, $CellContext`y] 
          Exp[I $CellContext`\[Alpha]$$]]}, {$CellContext`x, -10, 
         10}, {$CellContext`y, -10, 10}], 
      "Specifications" :> {{$CellContext`\[Alpha]$$, 0, 2 Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{404., {221., 226.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.910677301928589*^9, 3.910677649243299*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"4c4e5fe8-982a-4183-b1c2-0fa9117adfab"]
}, Open  ]],

Cell[TextData[{
 "In the above plot, you can see the vector plot for (Re \[Phi], Im ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"\[Phi]", ")"}], "T"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "2b58060c-c3e6-4de3-9efe-8bdff5471341"],
 ". Furthermore, you can see what happens when we multiply the configuration \
with a phase exp(i\[Alpha]). The arrows will change the direction, but at the \
end all plots describe one and the same vortex. You can see that this is a \
vortex, because when you go clockwise around the center, the arrows will also \
rotate clockwise.\nFor the anti-vortex the arrows will rotate anti-clockwise \
when you go clockwise around the center, as you can see in the following plot:"
}], "Text",
 CellChangeTimes->{{3.910676606159164*^9, 3.9106767416852818`*^9}, {
  3.910677221673195*^9, 
  3.9106772854898443`*^9}},ExpressionUUID->"df9708dc-7e71-40c2-a3ad-\
6549cece8b5f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PhiHatAnti", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{"-", "I"}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{
         RowBox[{"PhiHatAnti", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", "\[Alpha]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{
         RowBox[{"PhiHatAnti", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", "\[Alpha]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", 
     RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.910677309034266*^9, {3.910677641264934*^9, 3.910677646748468*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"e65f1c64-32cb-4073-961f-87baadf88163"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Alpha]$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Alpha]$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> VectorPlot[{
         Re[$CellContext`PhiHatAnti[$CellContext`x, $CellContext`y] 
          Exp[I $CellContext`\[Alpha]$$]], 
         Im[$CellContext`PhiHatAnti[$CellContext`x, $CellContext`y] 
          Exp[I $CellContext`\[Alpha]$$]]}, {$CellContext`x, -10, 
         10}, {$CellContext`y, -10, 10}], 
      "Specifications" :> {{$CellContext`\[Alpha]$$, 0, 2 Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{404., {221., 226.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.9106773107049837`*^9, 3.9106776472415047`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"203607ea-cb93-43cd-b5d0-691f02e745e6"]
}, Open  ]],

Cell["\<\
For two vortices you can just multiply the vortex solutions together:\
\>", "Text",
 CellChangeTimes->{{3.910677596026558*^9, 
  3.910677613932976*^9}},ExpressionUUID->"a95dbd0b-f470-49ef-8cb7-\
f7340e016015"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TwoVortices", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"PhiHat", "[", 
    RowBox[{
     RowBox[{"x", "-", "5"}], ",", "y"}], "]"}], "*", 
   RowBox[{"PhiHat", "[", 
    RowBox[{
     RowBox[{"x", "+", "5"}], ",", "y"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{
         RowBox[{"TwoVortices", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", "\[Alpha]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{
         RowBox[{"TwoVortices", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", "*", "\[Alpha]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", 
     RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.910677618353916*^9, 3.910677680521488*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"f320c217-5bee-4a9a-a7bf-11ab3f1b4a5b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Alpha]$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Alpha]$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> VectorPlot[{
         Re[$CellContext`TwoVortices[$CellContext`x, $CellContext`y] 
          Exp[I $CellContext`\[Alpha]$$]], 
         Im[$CellContext`TwoVortices[$CellContext`x, $CellContext`y] 
          Exp[I $CellContext`\[Alpha]$$]]}, {$CellContext`x, -10, 
         10}, {$CellContext`y, -10, 10}], 
      "Specifications" :> {{$CellContext`\[Alpha]$$, 0, 2 Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{404., {221., 226.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.9106776809814987`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"74fd7ac0-471f-4157-acab-5bbaced8bb08"]
}, Open  ]],

Cell["\<\
Fell free to play around with this Mathematica notebook. Try to do add \
further vortices. You can also analyse configurations with vortices and \
anti-vortices.\
\>", "Text",
 CellChangeTimes->{{3.910677698427367*^9, 
  3.910677748403914*^9}},ExpressionUUID->"5bd4b524-c327-4c10-ba8e-\
8ad777618723"]
}, Open  ]]
},
WindowSize->{1440, 762},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1250aa19-b48e-4cfc-853f-f5121a427a73"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 167, 3, 98, "Title",ExpressionUUID->"0ee00e5c-acc3-4005-a4b9-7f49da2e93ca"],
Cell[750, 27, 171, 3, 35, "Text",ExpressionUUID->"b12e6d83-ad70-4e3d-80a7-fe9588d48d2d"],
Cell[CellGroupData[{
Cell[946, 34, 1325, 37, 52, "Input",ExpressionUUID->"0fd0da47-f127-4a09-8311-f2e2b20b47eb"],
Cell[2274, 73, 1870, 37, 466, "Output",ExpressionUUID->"4c4e5fe8-982a-4183-b1c2-0fa9117adfab"]
}, Open  ]],
Cell[4159, 113, 941, 18, 81, "Text",ExpressionUUID->"df9708dc-7e71-40c2-a3ad-6549cece8b5f"],
Cell[CellGroupData[{
Cell[5125, 135, 1328, 38, 52, "Input",ExpressionUUID->"e65f1c64-32cb-4073-961f-87baadf88163"],
Cell[6456, 175, 1882, 37, 466, "Output",ExpressionUUID->"203607ea-cb93-43cd-b5d0-691f02e745e6"]
}, Open  ]],
Cell[8353, 215, 219, 5, 35, "Text",ExpressionUUID->"a95dbd0b-f470-49ef-8cb7-f7340e016015"],
Cell[CellGroupData[{
Cell[8597, 224, 1364, 39, 52, "Input",ExpressionUUID->"f320c217-5bee-4a9a-a7bf-11ab3f1b4a5b"],
Cell[9964, 265, 1861, 37, 466, "Output",ExpressionUUID->"74fd7ac0-471f-4157-acab-5bbaced8bb08"]
}, Open  ]],
Cell[11840, 305, 311, 7, 35, "Text",ExpressionUUID->"5bd4b524-c327-4c10-ba8e-8ad777618723"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

