(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      7481,        224]
NotebookOptionsPosition[      6630,        203]
NotebookOutlinePosition[      7024,        219]
CellTagsIndexPosition[      6981,        216]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"n", "*", "\[Phi]"}], "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n", "*", "\[Phi]"}], "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.910408896599495*^9, 3.910408954014102*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"bf7a2a97-899c-4a51-a767-0c83e1e3b097"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Element]", "Reals"}], ",", 
     RowBox[{"y", "\[Element]", "Reals"}], ",", 
     RowBox[{"z", "\[Element]", "Reals"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Phi]", "=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"y", "/", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", 
   RowBox[{"ArcCos", "[", 
    RowBox[{"z", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.910408961016259*^9, 3.910409034552918*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"819016e7-fc20-463c-bd95-8ee1b1deeb3e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"LeviCivitaTensor", "[", "3", "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"[", "a", "]"}], "]"}], ",", "x"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"[", "b", "]"}], "]"}], ",", "y"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", "c", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
   "FullSimplify"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"LeviCivitaTensor", "[", "3", "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"[", "a", "]"}], "]"}], ",", "x"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"[", "b", "]"}], "]"}], ",", "z"}], "]"}], "*", 
          RowBox[{"w", "[", 
           RowBox[{"[", "c", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
   "FullSimplify"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"LeviCivitaTensor", "[", "3", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"[", "a", "]"}], "]"}], ",", "y"}], "]"}], "*", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"[", "b", "]"}], "]"}], ",", "z"}], "]"}], "*", 
         RowBox[{"w", "[", 
          RowBox[{"[", "c", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.910409050045959*^9, 3.910409050457493*^9}, {
  3.9104090974714317`*^9, 3.910409215917068*^9}, {3.9104093994201393`*^9, 
  3.9104094206799183`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"d8d988a4-82c5-4fad-a541-aa981a3ebeff"],

Cell[BoxData[
 FractionBox[
  RowBox[{"n", " ", "z"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 CellChangeTimes->{{3.910409211184472*^9, 3.9104092162349453`*^9}, 
   3.910409422198563*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"28d06fd6-c494-4445-8410-9dc81d10ee1d"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"n", " ", "y"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output",
 CellChangeTimes->{{3.910409211184472*^9, 3.9104092162349453`*^9}, 
   3.9104094222181463`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"39a19beb-8a0d-48e9-a260-3f2e03affb2e"],

Cell[BoxData[
 FractionBox[
  RowBox[{"n", " ", "x"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 CellChangeTimes->{{3.910409211184472*^9, 3.9104092162349453`*^9}, 
   3.910409422234889*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"44d15466-e82f-4f07-8ba4-c5ff996b7fcf"]
}, Open  ]]
},
WindowSize->{808, 662},
WindowMargins->{{235, Automatic}, {-1, Automatic}},
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"59a9476c-f62a-4188-884d-7113df8f2884"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 568, 15, 30, "Input",ExpressionUUID->"bf7a2a97-899c-4a51-a767-0c83e1e3b097"],
Cell[1129, 37, 824, 23, 73, "Input",ExpressionUUID->"819016e7-fc20-463c-bd95-8ee1b1deeb3e"],
Cell[CellGroupData[{
Cell[1978, 64, 3303, 93, 178, "Input",ExpressionUUID->"d8d988a4-82c5-4fad-a541-aa981a3ebeff"],
Cell[5284, 159, 432, 12, 55, "Output",ExpressionUUID->"28d06fd6-c494-4445-8410-9dc81d10ee1d"],
Cell[5719, 173, 460, 13, 55, "Output",ExpressionUUID->"39a19beb-8a0d-48e9-a260-3f2e03affb2e"],
Cell[6182, 188, 432, 12, 55, "Output",ExpressionUUID->"44d15466-e82f-4f07-8ba4-c5ff996b7fcf"]
}, Open  ]]
}
]
*)

