(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30269,        852]
NotebookOptionsPosition[     26539,        777]
NotebookOutlinePosition[     26973,        794]
CellTagsIndexPosition[     26930,        791]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Problem 1.2", "Title",
 CellChangeTimes->{{3.908597439567841*^9, 3.9085974431857233`*^9}, {
  3.908601400635881*^9, 
  3.9086014028581343`*^9}},ExpressionUUID->"80a742ca-b9ec-4a8a-9028-\
3afffb104f45"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]", "=", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"u", " ", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"\[Gamma]", " ", "x"}], "]"}], "/", 
       RowBox[{"Cosh", "[", 
        RowBox[{"\[Gamma]", " ", "u", " ", "t"}], "]"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"1", "/", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"u", " ", "\[Element]", " ", "Reals"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.908597347475061*^9, 3.908597425578988*^9}, {
   3.908597616296336*^9, 3.908597650426168*^9}, {3.9085980113442698`*^9, 
   3.908598022914012*^9}, 3.908598199579762*^9, 3.908599730383205*^9},
 CellLabel->"In[37]:=",ExpressionUUID->"cf69b5c5-b105-4e02-bdaa-fc6a1f28a22f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Term1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}]}], "]"}], "-", 
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.9085977460792093`*^9, 3.908597789119577*^9}, {
  3.908597880965828*^9, 3.9085978820539007`*^9}, {3.910066411922311*^9, 
  3.910066419597753*^9}, {3.9100665038742743`*^9, 3.910066529124227*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"1a2eb86e-b1f0-456c-a575-204dd808f168"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "u", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["u", "2"], "+", 
      RowBox[{"Cosh", "[", 
       FractionBox[
        RowBox[{"2", " ", "t", " ", "u"}], 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["u", "2"]}]]], "]"}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"Cosh", "[", 
        FractionBox[
         RowBox[{"2", " ", "x"}], 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}]]], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      FractionBox[
       RowBox[{"t", " ", "u"}], 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"]}]]], "]"}], "3"], " ", 
    RowBox[{"Sinh", "[", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["u", "2"]}]]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sech", "[", 
         FractionBox[
          RowBox[{"t", " ", "u"}], 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["u", "2"]}]]], "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         FractionBox["x", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["u", "2"]}]]], "]"}], "2"]}]}], ")"}], 
    "2"]]}]], "Output",
 CellChangeTimes->{{3.9085977518729067`*^9, 3.908597790582073*^9}, 
   3.9085978831908903`*^9, 3.9085980274791727`*^9, 3.9085982078050413`*^9, 
   3.9100605363927402`*^9, {3.910066412497079*^9, 3.910066420871295*^9}, {
   3.910066492118513*^9, 3.91006652987245*^9}},
 CellLabel->"Out[45]=",ExpressionUUID->"5a0e5c9a-6e9c-4958-a55a-9a2ae117ccde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Term2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "\[Phi]", "]"}], "//", "TrigExpand"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.908597836560205*^9, 3.908597885529098*^9}, 
   3.910060549505288*^9, {3.910066430992333*^9, 3.910066451907098*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"5938416a-ab90-4e6d-9711-6ffecbf99239"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"4", " ", "u", " ", 
    RowBox[{"Sech", "[", 
     FractionBox[
      RowBox[{"t", " ", "u"}], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["u", "2"]}]]], "]"}], " ", 
    RowBox[{"Sinh", "[", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["u", "2"]}]]], "]"}]}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["u", "3"], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      FractionBox[
       RowBox[{"t", " ", "u"}], 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"]}]]], "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      FractionBox["x", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"]}]]], "]"}], "3"]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["u", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sech", "[", 
        FractionBox[
         RowBox[{"t", " ", "u"}], 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}]]], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        FractionBox["x", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}]]], "]"}], "2"]}]}], ")"}], 
   "2"]]], "Output",
 CellChangeTimes->{{3.9085978457989473`*^9, 3.90859785586121*^9}, 
   3.90859788626718*^9, 3.908598038661447*^9, 3.908598209492918*^9, {
   3.910060544601706*^9, 3.910060574091961*^9}, {3.910066432739835*^9, 
   3.9100664539058867`*^9}, 3.9100664942719584`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"3398d493-8d54-4488-ac28-8666d4a64746"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Term1", "+", "Term2"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.90859788759416*^9, 3.9085978967308283`*^9}, {
  3.908598188908876*^9, 3.908598189374009*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"c6d13ea3-98ce-43c9-8d72-44dc2c871aa3"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.908597890966914*^9, 3.908597897347715*^9}, 
   3.9085980404719954`*^9, {3.908598189799746*^9, 3.9085982108310547`*^9}, {
   3.9100664784184647`*^9, 3.9100665322411537`*^9}},
 CellLabel->"Out[46]=",ExpressionUUID->"0e1db0cc-a6e7-4bfd-97bf-68204d536bcd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1.3", "Title",
 CellChangeTimes->{{3.908598232242095*^9, 3.90859823425664*^9}, {
  3.908601404417304*^9, 
  3.90860140498633*^9}},ExpressionUUID->"f433401c-939e-411b-89f2-\
ea98d30e2ac1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Phi]", "/.", 
       RowBox[{"u", "->", "u1"}]}], "/.", 
      RowBox[{"t", "->", "t1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", 
     RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908598243470587*^9, 3.908598315441058*^9}, {
  3.908598369541009*^9, 3.908598414424214*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"ddb1fdde-075f-4cfd-a9b4-bdacba563876"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t1$$ = 34., $CellContext`u1$$ = 0.736, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u1$$], 0, 1}, {
      Hold[$CellContext`t1$$], -100, 100}}, Typeset`size$$ = {
    360., {108., 112.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`t1$$ = -100, $CellContext`u1$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         ReplaceAll[$CellContext`\[Phi], $CellContext`u -> \
$CellContext`u1$$], $CellContext`t -> $CellContext`t1$$], {$CellContext`x, \
-100, 100}, PlotRange -> All], 
      "Specifications" :> {{$CellContext`u1$$, 0, 
         1}, {$CellContext`t1$$, -100, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{404., {194., 199.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.908598300165311*^9, 3.908598317169866*^9}, {
   3.908598371867798*^9, 3.9085984399532146`*^9}, {3.91006062917878*^9, 
   3.9100606319147577`*^9}, 3.910066635019464*^9, 3.910066679502363*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"4efdefce-6ee8-46b6-a599-cfcaa10fcce5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1.4", "Title",
 CellChangeTimes->{{3.908599350968215*^9, 3.908599352531678*^9}, {
  3.9086014076205482`*^9, 
  3.90860140772792*^9}},ExpressionUUID->"76d43753-d3bf-4bd4-8482-\
deab925f865f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "\[Element]", " ", "Reals"}], ",", 
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"u", "\[Element]", "Reals"}], ",", 
     RowBox[{"u", ">", "0"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.908599739260054*^9, 3.908599748393814*^9}, {
  3.908600138725181*^9, 3.908600140794239*^9}, {3.908600323230047*^9, 
  3.908600330825914*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"f68b98ad-eff9-4652-8663-f7301dabe50c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Int1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", "x", "]"}], "^", "2"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"a", "*", 
         RowBox[{
          RowBox[{"Sinh", "[", "x", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "2"}]}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908599362607894*^9, 3.908599401274747*^9}, {
  3.9085994500394707`*^9, 3.908599498826603*^9}, {3.9085996560673532`*^9, 
  3.9085996635130157`*^9}, {3.9086001430462713`*^9, 3.9086001831851482`*^9}, {
  3.910067357535989*^9, 3.9100673595601377`*^9}, {3.9100674117725143`*^9, 
  3.9100674142535048`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"bbaf57ec-1889-4460-bd18-b3d379c1a622"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}]], " ", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "a"}]]}]], "+", 
  FractionBox[
   RowBox[{"Sinh", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", "a", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.9086001777829037`*^9, 3.9086001838242064`*^9}, 
   3.910060670172471*^9, {3.910067351677668*^9, 3.910067366601594*^9}, 
   3.9100674169798803`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"edbfb701-fa03-4bcf-8d25-72cd5039055b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"2", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"2", "-", "a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"2", "x"}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"x", "->", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"2", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"2", "-", "a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"2", "x"}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"x", "->", 
    RowBox[{"-", "Infinity"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9086000047652273`*^9, 3.908600005170415*^9}, {
  3.908600060638749*^9, 3.908600071982174*^9}, {3.9086001501825113`*^9, 
  3.908600150610623*^9}, {3.908600186952915*^9, 3.9086002742271233`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"a29bdb37-d459-4391-afe5-8247598a13f9"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", "a"}]]], "Output",
 CellChangeTimes->{
  3.908600005935081*^9, 3.908600064031837*^9, {3.908600135530754*^9, 
   3.908600151047007*^9}, {3.9086002202380953`*^9, 3.908600274577074*^9}, 
   3.910060673528603*^9, 3.910067450877133*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"f63ce9ba-20af-4a21-b7db-33baa3b4c7ee"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"2", " ", "a"}]]}]], "Output",
 CellChangeTimes->{
  3.908600005935081*^9, 3.908600064031837*^9, {3.908600135530754*^9, 
   3.908600151047007*^9}, {3.9086002202380953`*^9, 3.908600274577074*^9}, 
   3.910060673528603*^9, 3.91006745088308*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"499f62a2-19f8-4e71-beb8-d003767cc65f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Int2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"u", "*", 
         RowBox[{"Sinh", "[", "x", "]"}]}], "]"}]}], "]"}], "^", "2"}], ",", 
    "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.908600287856287*^9, 3.908600374296113*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"eabd6f83-7b69-46d4-9860-e39d86bef4e6"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["u", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ArcTan", "[", 
          FractionBox[
           RowBox[{"u", "-", 
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"Tanh", "[", 
              FractionBox["x", "2"], "]"}]}]}], 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"]}]]], "]"}], "-", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           RowBox[{"u", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"Tanh", "[", 
              FractionBox["x", "2"], "]"}]}]}], 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["u", "2"]}]]], "]"}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["u", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"Cosh", "[", "x", "]"}], " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["u", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sinh", "[", "x", "]"}], "2"]}]}], ")"}]}]]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.908600352339779*^9, 3.90860037503551*^9}, 
   3.9100606825305033`*^9, 3.910067621099162*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"a46ae870-712d-4ba3-b80f-e051ad07e8c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cosh", "[", "x", "]"}], " ", 
       RowBox[{"Sinh", "[", "x", "]"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"u", "^", "2"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"u", "^", "2"}], " ", 
         RowBox[{
          RowBox[{"Sinh", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}], ")"}]}], 
   ",", 
   RowBox[{"x", "->", "Infinity"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cosh", "[", "x", "]"}], " ", 
       RowBox[{"Sinh", "[", "x", "]"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"u", "^", "2"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"u", "^", "2"}], " ", 
         RowBox[{
          RowBox[{"Sinh", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}], ")"}]}], 
   ",", 
   RowBox[{"x", "->", 
    RowBox[{"-", "Infinity"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.908600392659634*^9, 3.908600431703158*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"d2da0d2e-d922-4d3e-90f0-4ce2a029ced6"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["u", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["u", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.908600399376759*^9, 3.90860043204629*^9}, 
   3.91006068874244*^9, 3.9100676918470716`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"cd58e1e9-a33a-4d08-96c1-73d6b8fa264b"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox["u", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["u", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.908600399376759*^9, 3.90860043204629*^9}, 
   3.91006068874244*^9, 3.910067691849225*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"16db4919-3bba-45ab-a5b7-e829b958e8a1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1.5", "Title",
 CellChangeTimes->{{3.908601445096457*^9, 
  3.908601446609795*^9}},ExpressionUUID->"de324b72-cb7a-4045-82d1-\
aedb0046ed58"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]", "=", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"1", "/", "u"}], " ", "*", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"\[Gamma]", " ", "u", " ", "t"}], "]"}], "/", 
       RowBox[{"Cosh", "[", 
        RowBox[{"\[Gamma]", " ", "x"}], "]"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"1", "/", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"u", " ", "\[Element]", " ", "Reals"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9086014506014214`*^9, 3.908601462558131*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"b55a0a69-ad8e-473a-8d2b-6e50dd633c63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Phi]", "/.", 
       RowBox[{"u", "->", "u1"}]}], "/.", 
      RowBox[{"t", "->", "t1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u1", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", 
     RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.90860148719767*^9, 3.908601487945759*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"3ef772f0-869a-4758-a554-2598cab87a51"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t1$$ = -53., $CellContext`u1$$ = 0.529, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u1$$], 0.01, 1}, {
      Hold[$CellContext`t1$$], -100, 100}}, Typeset`size$$ = {
    360., {109., 113.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`t1$$ = -100, $CellContext`u1$$ = 0.01}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         ReplaceAll[$CellContext`\[Phi], $CellContext`u -> \
$CellContext`u1$$], $CellContext`t -> $CellContext`t1$$], {$CellContext`x, \
-100, 100}, PlotRange -> All], 
      "Specifications" :> {{$CellContext`u1$$, 0.01, 
         1}, {$CellContext`t1$$, -100, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{404., {195., 200.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.908601477016328*^9, 3.90860148838286*^9}, {
  3.910060719471005*^9, 3.9100607240162153`*^9}, {3.910068377202285*^9, 
  3.9100683982691727`*^9}},
 CellLabel->"Out[58]=",ExpressionUUID->"479dffd9-8f08-4f64-95c3-7bd4fa53b1f0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1.6", "Title",
 CellChangeTimes->{{3.908601643586779*^9, 
  3.908601645772706*^9}},ExpressionUUID->"dfb81733-b96a-4f9b-99c7-\
e96945b1fd3e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]", "=", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"1", "/", "s"}], " ", "*", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Gamma]", " ", "s", " ", "t"}], "]"}], "/", 
       RowBox[{"Cosh", "[", 
        RowBox[{"\[Gamma]", " ", "x"}], "]"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"1", "/", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["s", "2"]}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"s", " ", "\[Element]", " ", "Reals"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9086016532505503`*^9, 3.908601667634328*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"78b5d36b-b002-4118-b900-f89d2bf1b30f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Phi]", "/.", 
       RowBox[{"s", "->", "s1"}]}], "/.", 
      RowBox[{"t", "->", "t1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7"}], ",", "7"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s1", ",", "0.01", ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", 
     RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.90860168796315*^9, 3.9086016927230787`*^9}, {
  3.908601728376834*^9, 3.908601729462851*^9}, {3.908601789265361*^9, 
  3.908601828515921*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"f52d3406-8758-4fac-aeaa-8f4a982aa550"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s1$$ = 
    0.0807, $CellContext`t1$$ = -97.2036361694336, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`s1$$], 0.01, 0.1}, {
      Hold[$CellContext`t1$$], -100, 100}}, Typeset`size$$ = {
    360., {109., 114.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`s1$$ = 0.01, $CellContext`t1$$ = -100}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         ReplaceAll[$CellContext`\[Phi], $CellContext`s -> \
$CellContext`s1$$], $CellContext`t -> $CellContext`t1$$], {$CellContext`x, \
-10, 10}, PlotRange -> {-7, 7}], 
      "Specifications" :> {{$CellContext`s1$$, 0.01, 
         0.1}, {$CellContext`t1$$, -100, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{404., {182., 187.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.908601694003092*^9, 3.9086017298111553`*^9}, {
  3.908601763616523*^9, 3.908601832850019*^9}, {3.9100607523561783`*^9, 
  3.910060778949945*^9}, {3.910068530136992*^9, 3.910068544949551*^9}},
 CellLabel->"Out[67]=",ExpressionUUID->"a9fc40a2-2103-4e7d-943a-05e03a6c89f5"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440, 762},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
TaggingRules-><|"TryRealOnly" -> False|>,
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"4d4fc042-58da-4af5-9036-3f5336e83545"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 207, 4, 98, "Title",ExpressionUUID->"80a742ca-b9ec-4a8a-9028-3afffb104f45"],
Cell[790, 28, 927, 24, 82, "Input",ExpressionUUID->"cf69b5c5-b105-4e02-bdaa-fc6a1f28a22f"],
Cell[CellGroupData[{
Cell[1742, 56, 643, 16, 30, "Input",ExpressionUUID->"1a2eb86e-b1f0-456c-a575-204dd808f168"],
Cell[2388, 74, 1836, 56, 84, "Output",ExpressionUUID->"5a0e5c9a-6e9c-4958-a55a-9a2ae117ccde"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4261, 135, 380, 8, 30, "Input",ExpressionUUID->"5938416a-ab90-4e6d-9711-6ffecbf99239"],
Cell[4644, 145, 1686, 53, 83, "Output",ExpressionUUID->"3398d493-8d54-4488-ac28-8666d4a64746"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6367, 203, 287, 5, 30, "Input",ExpressionUUID->"c6d13ea3-98ce-43c9-8d72-44dc2c871aa3"],
Cell[6657, 210, 303, 4, 34, "Output",ExpressionUUID->"0e1db0cc-a6e7-4bfd-97bf-68204d536bcd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7009, 220, 201, 4, 98, "Title",ExpressionUUID->"f433401c-939e-411b-89f2-ea98d30e2ac1"],
Cell[CellGroupData[{
Cell[7235, 228, 747, 20, 30, "Input",ExpressionUUID->"ddb1fdde-075f-4cfd-a9b4-bdacba563876"],
Cell[7985, 250, 2036, 41, 412, "Output",ExpressionUUID->"4efdefce-6ee8-46b6-a599-cfcaa10fcce5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10070, 297, 204, 4, 98, "Title",ExpressionUUID->"76d43753-d3bf-4bd4-8482-deab925f865f"],
Cell[10277, 303, 530, 12, 30, "Input",ExpressionUUID->"f68b98ad-eff9-4652-8663-f7301dabe50c"],
Cell[CellGroupData[{
Cell[10832, 319, 787, 19, 30, "Input",ExpressionUUID->"bbaf57ec-1889-4460-bd18-b3d379c1a622"],
Cell[11622, 340, 819, 25, 60, "Output",ExpressionUUID->"edbfb701-fa03-4bcf-8d25-72cd5039055b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12478, 370, 1108, 31, 52, "Input",ExpressionUUID->"a29bdb37-d459-4391-afe5-8247598a13f9"],
Cell[13589, 403, 363, 7, 50, "Output",ExpressionUUID->"f63ce9ba-20af-4a21-b7db-33baa3b4c7ee"],
Cell[13955, 412, 381, 8, 50, "Output",ExpressionUUID->"499f62a2-19f8-4e71-beb8-d003767cc65f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14373, 425, 452, 12, 30, "Input",ExpressionUUID->"eabd6f83-7b69-46d4-9860-e39d86bef4e6"],
Cell[14828, 439, 1672, 51, 123, "Output",ExpressionUUID->"a46ae870-712d-4ba3-b80f-e051ad07e8c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16537, 495, 1424, 47, 52, "Input",ExpressionUUID->"d2da0d2e-d922-4d3e-90f0-4ce2a029ced6"],
Cell[17964, 544, 410, 11, 56, "Output",ExpressionUUID->"cd58e1e9-a33a-4d08-96c1-73d6b8fa264b"],
Cell[18377, 557, 384, 10, 56, "Output",ExpressionUUID->"16db4919-3bba-45ab-a5b7-e829b958e8a1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18810, 573, 154, 3, 98, "Title",ExpressionUUID->"de324b72-cb7a-4045-82d1-aedb0046ed58"],
Cell[18967, 578, 815, 23, 82, "Input",ExpressionUUID->"b55a0a69-ad8e-473a-8d2b-6e50dd633c63"],
Cell[CellGroupData[{
Cell[19807, 605, 701, 19, 30, "Input",ExpressionUUID->"3ef772f0-869a-4758-a554-2598cab87a51"],
Cell[20511, 626, 2001, 41, 414, "Output",ExpressionUUID->"479dffd9-8f08-4f64-95c3-7bd4fa53b1f0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22561, 673, 154, 3, 98, "Title",ExpressionUUID->"dfb81733-b96a-4f9b-99c7-e96945b1fd3e"],
Cell[22718, 678, 814, 23, 82, "Input",ExpressionUUID->"78b5d36b-b002-4118-b900-f89d2bf1b30f"],
Cell[CellGroupData[{
Cell[23557, 705, 878, 24, 30, "Input",ExpressionUUID->"f52d3406-8758-4fac-aeaa-8f4a982aa550"],
Cell[24438, 731, 2073, 42, 411, "Output",ExpressionUUID->"a9fc40a2-2103-4e7d-943a-05e03a6c89f5"]
}, Open  ]]
}, Open  ]]
}
]
*)

