(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     35914,        882]
NotebookOptionsPosition[     34315,        847]
NotebookOutlinePosition[     34780,        865]
CellTagsIndexPosition[     34737,        862]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Energy of Vacuum Layers", "Title",
 CellChangeTimes->{{3.9078448932444353`*^9, 
  3.9078448974992456`*^9}},ExpressionUUID->"47c18cae-375d-4784-aa0d-\
885783775604"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Phi0v", "[", "x_", "]"}], ":=", 
   RowBox[{"v", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "mh"}], "*", "x"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Phiv0", "[", "x_", "]"}], ":=", 
   RowBox[{"v", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{"Exp", "[", 
       RowBox[{"mh", "*", "x"}], "]"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907737307089254*^9, 3.907737370876348*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"d17eb5af-4a70-4907-bf97-12721b5e7b45"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mh", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lambda", "=", 
   RowBox[{
    RowBox[{"mh", "^", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"8", "*", 
      RowBox[{"v", "^", "4"}]}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907737374960607*^9, 3.90773738039312*^9}, {
  3.9077374288254423`*^9, 3.907737462651432*^9}, {3.907737596024379*^9, 
  3.907737602817531*^9}, {3.907737634444531*^9, 3.907737672630755*^9}, {
  3.90773787884068*^9, 3.9077378788919353`*^9}, {3.9077380075568247`*^9, 
  3.907738033570929*^9}, {3.907738140491796*^9, 3.907738141118202*^9}, {
  3.907839460769577*^9, 3.907839463078206*^9}, {3.907841883277486*^9, 
  3.907841883365355*^9}, {3.907843696316128*^9, 3.907843697180615*^9}, {
  3.907843975722376*^9, 3.907843982262045*^9}, {3.907844532559216*^9, 
  3.907844532641766*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"7d21ae7e-a2c0-4a5c-8516-950af2b4a100"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Phi0v0", "[", 
    RowBox[{"x_", ",", "h_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "/", "v"}], "*", 
    RowBox[{"Phi0v", "[", "x", "]"}], "*", 
    RowBox[{"Phiv0", "[", 
     RowBox[{"x", "-", "h"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Phiv0v", "[", 
    RowBox[{"x_", ",", "h_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Phiv0", "[", "x", "]"}], "+", 
    RowBox[{"Phi0v", "[", 
     RowBox[{"x", "-", "h"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Phiv0mv", "[", 
    RowBox[{"x_", ",", "h_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Phiv0", "[", "x", "]"}], "-", 
    RowBox[{"Phi0v", "[", 
     RowBox[{"x", "-", "h"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907737385818198*^9, 3.9077374223200073`*^9}, {
   3.907737483433324*^9, 3.907737511981146*^9}, {3.9077377750920143`*^9, 
   3.907737873417654*^9}, {3.90773804421882*^9, 3.907738045756117*^9}, {
   3.907738083140571*^9, 3.9077381383344593`*^9}, {3.907839455401132*^9, 
   3.907839457481518*^9}, {3.907843704568598*^9, 3.907843812520318*^9}, 
   3.9078438737517138`*^9, {3.907843988810951*^9, 3.907843993670064*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"c6daf8e2-a7c4-46f3-bdc3-94d716b26b90"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DPhi0v0", "[", "h_", "]"}], ":=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Phi0v0", "[", 
      RowBox[{"x", ",", "h"}], "]"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DPhiv0v", "[", "h_", "]"}], ":=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Phiv0v", "[", 
      RowBox[{"x", ",", "h"}], "]"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DPhiv0mv", "[", "h_", "]"}], ":=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Phiv0mv", "[", 
      RowBox[{"x", ",", "h"}], "]"}], ",", "x"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9077374733979797`*^9, 3.907737481564322*^9}, {
  3.90784383090735*^9, 3.907843870790612*^9}, {3.907843995429178*^9, 
  3.9078440268308563`*^9}, {3.9078442678566427`*^9, 3.907844272920949*^9}, {
  3.907844337385392*^9, 3.907844345640841*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"85549584-aae0-44f6-9f72-c91961e40dbd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"E0v0", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "*", 
         RowBox[{
          RowBox[{"DPhi0v0", "[", "h", "]"}], "^", "2"}]}], "+", 
        RowBox[{"lambda", "*", 
         RowBox[{
          RowBox[{"Phi0v0", "[", 
           RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Phi0v0", "[", 
              RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "-", 
            RowBox[{"v", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "2", ",", "20", ",", "0.4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ev0v", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "*", 
         RowBox[{
          RowBox[{"DPhiv0v", "[", "h", "]"}], "^", "2"}]}], "+", 
        RowBox[{"lambda", "*", 
         RowBox[{
          RowBox[{"Phiv0v", "[", 
           RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Phiv0v", "[", 
              RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "-", 
            RowBox[{"v", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "2", ",", "20", ",", "0.4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ev0mv", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "*", 
         RowBox[{
          RowBox[{"DPhiv0mv", "[", "h", "]"}], "^", "2"}]}], "+", 
        RowBox[{"lambda", "*", 
         RowBox[{
          RowBox[{"Phiv0mv", "[", 
           RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Phiv0mv", "[", 
              RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "-", 
            RowBox[{"v", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "2", ",", "20", ",", "0.4"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.907843906100338*^9, 3.907843966342368*^9}, {
  3.907844029762322*^9, 3.907844119636174*^9}, {3.90784415148623*^9, 
  3.907844207626307*^9}, {3.907844369668672*^9, 3.907844429415221*^9}, {
  3.907844477604415*^9, 3.907844509709581*^9}, {3.907844622646592*^9, 
  3.9078446582519913`*^9}, {3.907844824337063*^9, 3.90784482753371*^9}, {
  3.908283877010929*^9, 
  3.908283882016117*^9}},ExpressionUUID->"fc83433c-d018-4ff5-9835-\
ed77a07b461d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"E2DW", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0.25", ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "2", ",", "20", ",", "0.4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"E0v0", ",", "Ev0v", ",", "Ev0mv", ",", "E2DW"}], "}"}], ",", 
   RowBox[{"Joined", "->", "True"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"{", 
       RowBox[{"Dashed", ",", "Black"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<0v0\>\"", ",", "\"\<v0v\>\"", ",", "\"\<v0mv\>\""}], 
     "}"}]}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9078444011920967`*^9, 3.907844463892056*^9}, {
  3.907844547612588*^9, 3.907844557386565*^9}, {3.907844594934513*^9, 
  3.907844598972636*^9}, {3.907844642549079*^9, 3.907844644397998*^9}, {
  3.907844702151042*^9, 3.907844829047676*^9}, {3.907845313346443*^9, 
  3.907845333528365*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"ef8c836a-dcab-45f1-ae0b-9de9760d2661"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQEf7Hdo7Zuw98Epe6iAQ7RCTtZc7TNQPoeDes/C
248MzkL5Ag6Slzel+/6E8UUcxP/UNpv0n4PyJRzUnx1ze/cHxpdxaFnjmnvW
+zyUr+AQqPV/2rJmGF/JIf7of/Htq2B8FQeBGZ93Hj0K46s5/FWs54q7AeNr
OJx/ILpE8CmMr+WwyOSq+Za3ML6Og+yLzwt7P8P4eg7LVnLpNX6H8Q0cakVe
SWr/gvENHcKPlEh9+w3jGzn8efB/i9ZfGN/YIc3lGcsvON/E4Vtgk3HrPxjf
1EG+kn/WIzjfzMHibpuT4n8Y39xhpvpND28438Ih6qlDeTqcb+lQ/nhKTBWc
b+XganySvR3Ot3YwOiPc1g/n2zgwG28wnwrn2zpEu13mmAnn2zlsfHFj+mw4
397hmvsHv7lwvoODwza30nkwfoODQ1vnFKv5cHlHhzOO1/fB+Q2ODnuW1Ikv
gMs7OSw6+SYIzm9wcnDfe6gKIe/sYOVdNhUh7+zQOT1mOULexWGzccxmhLyL
g5dW+m6EvKvD9lvnDyDkXR0WcGUeQci7OThqXj2GkHdzaLxecgIh7+6gMaX7
JIgPAIMn7BQ=
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw1yWtIkwEUxvE3uyjYBwkJP4hd5obZWlnOtJzv4+ZWFH1wkEhRNC+UMDBJ
KKTLJiWEmcycW0FFlkk51iwM8cayEDWXZBZmrZhdzFoz7WKjZhmdc+Bw+J3/
irxifWGYIAiKuf13/88XMTq0f2Zv/gWRHpBN2r/HR54mRyDdOP/AsUW15Ch8
lRecU45cJUdjRt9VUaVxkWPgOJUb1R28S45FzRXHwgJjJ3k5LNZXB63198gr
sVhsNIbWPiDHw7Nsp9q9u4csw7b6G37P6l5yAoS4Gl3qzT5yIo66bl0qGesn
yyE7Lgtve/2QrEDdIYk/2zFAXoei27aQNNtDTsLJ7b6P7qfs9Xji/OMx4BF5
A0x9zRGSOnYy1qSkTUhfsJUovmjwdiwZJKfA61XrLCJ7IypaL7+9n89OReXQ
4Gi4mZ2G0j2d7a129iaMV5UX+pvYm2Fr3pFsbmenI2bBGcOqXrYK17TP5pUO
sTOQs+uxdHiULaJNdfbEdR8bMH+Ie6kcJ5uAwDu3q+sT90wk5g58Lpnknokj
I2UZh6e5q2FNeDMc+MZdDUtZ4Pn0D+4aOFsqa+0/uWtwXhLMmQpyz4ItdkIV
+Yt7Ft5Xd/RPsQUt9D7sc/7mrkV1Q0Pj1hB3HZZ25431sE06hBW1yBWz3Lcg
adZxp3zOfwGsQuP7
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw9yVtIkwEYxvFv0/JLcktyTWYytfgmOdfWwXTN7XFuTm9qxK6S0KxB0sEk
04qKDhRaF14YLRqd1MpNFDrQ4cZgLVo0UluWEIJ0wihikUQXlRl9Ty+8vPze
f35D0wa/UhAE0+z+vf8m6egYEZf0vx5zyA+cn1m3qCVMizAY2mq2NdAL8Mhv
H4yLdBY2DasLzD0vZGfja2PjwckSejF8moHOjlhCdh6UkmSZqaULkFUYmiia
fi57KSK5tmJdFy3hR+4bhdpKF2LyycD7/o+jspfBtDlavbCbNuKV6lJ7+hba
BI/Be1RrpM2477wbOfdzRLYFv7qH/OMJegV27roo6G7QK/F5957W3i56FS5I
x5tiB+jV0IYe29756RLoY52jfh+9BuYrD+ufuulSjF8tz+gpo8twJxlPO7Wc
tiLl20lvkYFei/Qz+3z2PNqGUvHl4RM6uhzBwYyxuIa241PkbGgqk3ZAVVez
47aKBqLHtMHM+bKPAO2ntyY+zGOvwOXAdaVeZK9AYHjiVt9cdieeNVvb9s5h
d0J68LZ+fyp7JVqM08FwCnslblZ/VylowQWPt1bdqmR34XeyLz+VFtzINjVH
rynY3dDXrXdtpIUqfNEcCuT871UIp91zTAnsHhTnbLcMzfoPEM7FJA==
         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], 
         GrayLevel[0]], 
        LineBox[CompressedData["
1:eJxdyUsKQQEUx+GTkaGBgYEBkiTJ+831NrcEZWwLlmgploCu1P1Onf59/arX
++WWi4jO57+b3itJ9/nb2GSdxwVcxCVcxhVcw3XcwE3cwm3cwV3cw308wEM8
wmM8wVM8w3O8wEu8wmuc4E3WDxxbOo4dHceejuNAx3Gk4zjRcZz/fgOZWkt+

         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.0625000000000001, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0.0625000000000001, 46.}, {0, 0.34153250142413377`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"0v0\"", "\"v0v\"", "\"v0mv\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.907844406985218*^9, 3.907844432216982*^9}, 
   3.907844464207459*^9, 3.907844552920247*^9, 3.9078445995309687`*^9, {
   3.9078446351717987`*^9, 3.9078446609624767`*^9}, {3.907844737048677*^9, 
   3.907844839725204*^9}, 3.907845334856132*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"bc503d30-68e3-4810-917b-f9a956598be1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Non-Static Configuration", "Title",
 CellChangeTimes->{{3.907844881978265*^9, 
  3.907844885389258*^9}},ExpressionUUID->"4ae267a1-0c93-4fd3-86fd-\
8cd33e33dc5f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Phiv0vBad", "[", 
    RowBox[{"x_", ",", "h_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "v"}], "*", 
     RowBox[{"Phi0v", "[", "x", "]"}], "*", 
     RowBox[{"Phiv0", "[", 
      RowBox[{"x", "-", "h"}], "]"}]}], "+", "v"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DPhiv0vBad", "[", "h_", "]"}], ":=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Phiv0vBad", "[", 
      RowBox[{"x", ",", "h"}], "]"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ev0vBad", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "*", 
         RowBox[{
          RowBox[{"DPhiv0vBad", "[", "h", "]"}], "^", "2"}]}], "+", 
        RowBox[{"lambda", "*", 
         RowBox[{
          RowBox[{"Phiv0vBad", "[", 
           RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Phiv0vBad", "[", 
              RowBox[{"x", ",", "h"}], "]"}], "^", "2"}], "-", 
            RowBox[{"v", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "2", ",", "20", ",", "0.4"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.907844902075293*^9, 3.9078449540931664`*^9}, {
  3.9078449907737827`*^9, 3.907845012436274*^9}, {3.908283887554429*^9, 
  3.908283888669796*^9}},ExpressionUUID->"ce57f2f9-d2e4-47ef-90e0-\
9e360f4fff0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Ev0v", ",", "Ev0vBad", ",", "E2DW"}], "}"}], ",", 
   RowBox[{"Joined", "->", "True"}], ",", " ", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"{", 
       RowBox[{"Dashed", ",", "Black"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<v0v\>\"", ",", "\"\<v0vBad\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.907845022090292*^9, 3.907845088072071*^9}, {
  3.907845343739142*^9, 3.907845360398295*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"bd582a8f-2e7c-4656-bd3d-1939d1c6d5c1"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw1yWtIkwEUxvE3uyjYBwkJP4hd5obZWlnOtJzv4+ZWFH1wkEhRNC+UMDBJ
KKTLJiWEmcycW0FFlkk51iwM8cayEDWXZBZmrZhdzFoz7WKjZhmdc+Bw+J3/
irxifWGYIAiKuf13/88XMTq0f2Zv/gWRHpBN2r/HR54mRyDdOP/AsUW15Ch8
lRecU45cJUdjRt9VUaVxkWPgOJUb1R28S45FzRXHwgJjJ3k5LNZXB63198gr
sVhsNIbWPiDHw7Nsp9q9u4csw7b6G37P6l5yAoS4Gl3qzT5yIo66bl0qGesn
yyE7Lgtve/2QrEDdIYk/2zFAXoei27aQNNtDTsLJ7b6P7qfs9Xji/OMx4BF5
A0x9zRGSOnYy1qSkTUhfsJUovmjwdiwZJKfA61XrLCJ7IypaL7+9n89OReXQ
4Gi4mZ2G0j2d7a129iaMV5UX+pvYm2Fr3pFsbmenI2bBGcOqXrYK17TP5pUO
sTOQs+uxdHiULaJNdfbEdR8bMH+Ie6kcJ5uAwDu3q+sT90wk5g58Lpnknokj
I2UZh6e5q2FNeDMc+MZdDUtZ4Pn0D+4aOFsqa+0/uWtwXhLMmQpyz4ItdkIV
+Yt7Ft5Xd/RPsQUt9D7sc/7mrkV1Q0Pj1hB3HZZ25431sE06hBW1yBWz3Lcg
adZxp3zOfwGsQuP7
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxFyVtI0wEUx/E/kuCDD4JT5I+RziEiIeW85XT77eLmDPZQMHyIkqlD3TQl
xEkK80EmiPoigvbihqLErPVQiZeB+JDXaTpLGPmgRYKUghAppSbtnP+Bw+Fz
vum2pw9qYwRByPm31/f/nGgG6q1jGuW6JvqAOJQ8GJGFoo6D21jtDm+QE1Du
rWkaq9uIWoa+rqQfqwfkFDh15puf5ZtRp2LysayuyExOA5qda8d2shwPgyce
fydZAV9HuWy/n5yJG5+0Ox9ekLNgLtjzPBonZyN7dE/h9JNvo7VNPBt6Q87B
SO/RWeVb8h2ILsOrhGnyXURMc5bYGXIuAqruX45ZshKmRsVXxxw5D1m2P1/S
58n52Gl/uetjF+DCE7r8yy6EPqMY6iC5CO/erzQ52PcQrFqW97KLEa6tsHrZ
KpReipEAuwTnzZ2vZ9mlsLbcUi2y1eh3JT5fYmsQkO+nrbGBpdbDyRDZDYz8
Tm7Y5K6FPyh6P3LXonJU5drirsOU+C1+m7sOcRM9z9iCHvYn1hmp6/EzUXEk
dQNsuQvxYe4G+CIHGWyhDD2N60qpl8HgmFdL3YjtEIxSN+K7vv6+1E0Ytpxa
rn0Fz2/ikQ==
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], 
         GrayLevel[0]], 
        LineBox[CompressedData["
1:eJxdyUsKQQEUx+GTkaGBgYEBkiTJ+831NrcEZWwLlmgploCu1P1Onf59/arX
++WWi4jO57+b3itJ9/nb2GSdxwVcxCVcxhVcw3XcwE3cwm3cwV3cw308wEM8
wmM8wVM8w3O8wEu8wmuc4E3WDxxbOo4dHceejuNAx3Gk4zjRcZz/fgOZWkt+

         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.0625000000000001, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0.0625000000000001, 46.}, {0, 0.26164729795457614`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"v0v\"", "\"v0vBad\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.907845070929078*^9, 3.9078450886083508`*^9}, 
   3.9078453609373283`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"72c1bde1-96ef-4a2c-b98e-dd87a53b90c0"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440, 847},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
TaggingRules-><|"TryRealOnly" -> False|>,
Magnification:>1.25 Inherited,
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8af14773-dc67-4bee-bccc-97bdb78067da"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 170, 3, 123, "Title",ExpressionUUID->"47c18cae-375d-4784-aa0d-885783775604"],
Cell[753, 27, 670, 20, 64, "Input",ExpressionUUID->"d17eb5af-4a70-4907-bf97-12721b5e7b45"],
Cell[1426, 49, 1018, 21, 90, "Input",ExpressionUUID->"7d21ae7e-a2c0-4a5c-8516-950af2b4a100"],
Cell[2447, 72, 1297, 32, 90, "Input",ExpressionUUID->"c6daf8e2-a7c4-46f3-bdc3-94d716b26b90"],
Cell[3747, 106, 1018, 28, 90, "Input",ExpressionUUID->"85549584-aae0-44f6-9f72-c91961e40dbd"],
Cell[4768, 136, 3207, 92, 90, "Input",ExpressionUUID->"fc83433c-d018-4ff5-9835-ed77a07b461d"],
Cell[CellGroupData[{
Cell[8000, 232, 1190, 28, 116, "Input",ExpressionUUID->"ef8c836a-dcab-45f1-ae0b-9de9760d2661"],
Cell[9193, 262, 12503, 274, 303, "Output",ExpressionUUID->"bc503d30-68e3-4810-917b-f9a956598be1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21745, 542, 167, 3, 123, "Title",ExpressionUUID->"4ae267a1-0c93-4fd3-86fd-8cd33e33dc5f"],
Cell[21915, 547, 1722, 52, 116, "Input",ExpressionUUID->"ce57f2f9-d2e4-47ef-90e0-9e360f4fff0a"],
Cell[CellGroupData[{
Cell[23662, 603, 722, 18, 37, "Input",ExpressionUUID->"bd582a8f-2e7c-4656-bd3d-1939d1c6d5c1"],
Cell[24387, 623, 9900, 220, 303, "Output",ExpressionUUID->"72c1bde1-96ef-4a2c-b98e-dd87a53b90c0"]
}, Open  ]]
}, Open  ]]
}
]
*)

