#define CATCH_CONFIG_MAIN
#include <inc/catch.hpp>
#include <inc/la_tools.h>
#include <ed/models.h>

TEST_CASE("Test gen_tfim")
{
    typedef Lattice::Spin::MatrixType MatrixType;
    typedef MatrixType::NumberType T;
    typedef MatrixType::BaseType B;

    Lattice::Spin lattice(0.5, 2);
    MatrixType H;

    B J = 0.0;
    B h = 1.0;

    models::gen_tfim(lattice, J, h, 0.0, H);
    REQUIRE(H == MatrixType(4, 4, {T(0.0), T(-1.0), T(-1.0), T(0.0),
                                   T(-1.0), T(0.0), T(0.0), T(-1.0),
                                   T(-1.0), T(0.0), T(0.0), T(-1.0),
                                   T(0.0), T(-1.0), T(-1.0), T(0.0)}));

    J = 1.0;
    h = 0.0;

    models::gen_tfim(lattice, J, h, 0.0, H);
    REQUIRE(H == MatrixType(4, 4, {T(-1.0), T(0.0), T(0.0), T(0.0),
                                   T(0.0), T(1.0), T(0.0), T(0.0),
                                   T(0.0), T(0.0), T(1.0), T(0.0),
                                   T(0.0), T(0.0), T(0.0), T(-1.0)}));
}