# input arguments:
# idir : string, directory containing data files
# odir : string, output directory
# J    : string with '.' replaced by 'p'
# h    : string with '.' replaced by 'p'
# hz   : string with '.' replaced by 'p'
#
# run with, e.g., gnuplot -e "idir='.'; odir='plots/finite_size_scaling'; J='1p0'; h='0p25'; hz='0p001'" plots/finite_size_scaling.plt

reset

filerump="run_J-".J."_h-".h."_hz-".hz

# create output directory if necessary
system("if [ ! -d ".odir." ]; then mkdir -p ".odir."; fi")

print(idir."/".filerump.".dat")

# extrapolate sx to thermodynamic limit
f1(x)=a1*x**b1+c1
fit [*:1/6.] f1(x) idir."/".filerump.".dat" u (1/$1):($7/$1) via a1,b1,c1

# extrapolate sz to thermodynamic limit
f2(x)=a2*x**b2+c2
fit [*:1/6.] f2(x) idir."/".filerump.".dat" u (1/$1):($8/$1) via a2,b2,c2

# extrapolate GS energy to thermodynamic limit
f3(x)=a3*x**2+b3*x+c3
fit [*:1/6.] f3(x) idir."/".filerump.".dat" u (1/$1):($6/$1) via a3,b3,c3

# and plot finite size scaling
set terminal png size 640,840
set output odir."/".filerump.".png"
set multiplot layout 2,1

set xlabel "1/L"
set ylabel "<S^{/Symbol a}>/L"
set key outside right
set title "Finite size scaling of S^x and S^y at J=".J.", h=".h.", hz= ".hz."\n".sprintf("S^x(L->∞)=%.5f(+/-%.5f), S^z(L->∞)=%.5f(+/-%.5f)", c1, c1_err, c2, c2_err)

# adjust y-range for sx-plots
min(x,y)=x<y?x:y
max(x,y)=x>y?x:y
stats idir."/".filerump.".dat" using ($7/$1) nooutput; sx_min=STATS_min; sx_max=STATS_max
stats idir."/".filerump.".dat" using ($8/$1) nooutput; sz_min=STATS_min; sz_max=STATS_max
ymin=min(min(c1, c2), min(sx_min, sz_min))
ymax=max(max(c1, c2), max(sx_max, sz_max))
margin=(ymax-ymin)*0.05

set yrange [ymin-margin:ymax+margin]
p [0:*] idir."/".filerump.".dat" u (1/$1):(($7/$1)) w p lc 4 t "<S^x>/L", (f1(x)) w l lc 4 lw 1 t "", (c1) lc 4 lw 2 dt 3 t "S^x(L->∞)", idir."/".filerump.".dat" u (1/$1):(($8/$1)) w p lc 3 t "<S^z>/L", (f2(x)) w l lc 3 lw 1 t "", (c2) lc 3 lw 2 dt 3 t "S^z(L->∞)"

set xlabel "1/L"
set ylabel "E_{GS}/L"
set key outside right
set title "Finite size scaling of E_{GS} at J=".J.", h=".h.", hz= ".hz."\n".sprintf("E_{GS}(L->∞)=%.5f(+/-%.5f)", c3, c3_err)

set yrange[*:*]
p [0:*] idir."/".filerump.".dat" u (1/$1):($6/$1) w lp lc 3 t "E_{GS}/L", f3(x) w l lc 3 lw 1 t "", c3 lc 3 lw 2 dt 3 t "E_{GS}(L->∞)"

unset multiplot

# print extrapolated values to stdout
set print "-"
print sprintf("%.16f %.16f %.16f %.16f %.16f %.16f", c1, c1_err, c2, c2_err, c3, c3_err)
