# input
# idir : string, input directory
# odir : string, output directory
# obs  : string, observable name, output file is obs.png
# col  : int, column in input files: 7 for sx, 8 for sz and 6 for egs
#
# call for instance with: gnuplot -e "idir='.'; odir='plots'; obs='sx'; col=7" plots/expectation_value.plt

reset

# first find all data files and sort by h-values
FILES=system("find ".idir." -maxdepth 1 -iname \"run_J-*_h-*_hz-*.dat\" | sort -t '-' -k3 -V | tr '\n' ' '")

# next get all available L-values
Ls=system("cat ".FILES." | grep -v '#' | awk '{print $1}' | sort -nu | tr '\n' ' '")

# create output directory if necessary
system("if [ ! -d ".odir." ]; then mkdir -p ".odir."; fi")

# set up axis
set xlabel "h/J"
set ylabel "<".obs.">/L"
set title sprintf("Avg. expectation value of ".obs." per site")
set grid

# position legend
set key center right

# and do plotting
set terminal png size 640,840
set output odir."/".obs.".png"
p for[I=1:words(Ls)] "<cat ".FILES." | awk '($1==".word(Ls,I).") {print}'" u ($3/$2):(column(col)/$1) w lp t sprintf("L=%s", word(Ls,I))
