# input
# idir : string, input directory
# odir : string, output directory
#
# call for instance with: gnuplot -e "idir='.'; odir='plots'" plots/sx.plt

reset

# first find all data files and sort by h-values
FILES=system("find ".idir." -maxdepth 1 -iname \"run_J-*_h-*_hz-*.dat\" | sort -t '-' -k3 -V | tr '\n' ' '")

# next get all available L-values
Ls=system("cat ".FILES." | grep -v '#' | awk '{print $1}' | sort -nu | tr '\n' ' '")

# small helper functions extracting J, h or hz from filename
get_value(file,idx)=system("echo ".file." | xargs basename | cut -d '_' -f".sprintf("%d",idx)." | cut -d '-' -f2 | sed \"s/p/\./g\"")
L(file)=get_value(file,1)
J(file)=get_value(file,2)
h(file)=get_value(file,3)
hz(file)=get_value(file,4)

# create output directory if necessary
system("if [ ! -d ".odir." ]; then mkdir -p ".odir."; fi")

# set up axis
set xlabel "h/J"
set ylabel "S^x/L"
set title sprintf("Avg. S^x per site")

# and do plotting
set terminal png size 640,840
set output odir."/sx.png"
p for[I=1:words(Ls)] "<cat ".FILES." | awk '($1==".word(Ls,I).") {print}'" u ($3/$2):($7/$1) w lp t sprintf("L=%s", word(Ls,I))
