#ifndef LA_OBJECTS
#define LA_OBJECTS

#include <la/la_base_obj.h>

namespace la_objects
{

template <typename T> class LAMatrix;

} // END NAMESPACE la_objects

#include <la/la_expressions.h>

namespace la_operations {

// template<typename E, typename X>
// static void apply(E, const Expression<X> &);

template <typename Type>
void add(const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

template <typename Type>
void add(const Type&, const la_objects::LAMatrix<Type>&, const Type&, const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

template <typename Type>
void contract(const la_objects::LAMatrix<Type>&, char, const la_objects::LAMatrix<Type>&, char, const Type&, const la_objects::LAMatrix<Type>&, const Type&, la_objects::LAMatrix<Type>&);

template <typename Type>
void contract(const la_objects::LAMatrix<Type>&, char, const la_objects::LAMatrix<Type>&, char, la_objects::LAMatrix<Type>&);

template <typename Type>
void contract(const la_objects::LAMatrix<Type>&, const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

template <typename Type>
void kronecker(const la_objects::LAMatrix<Type>&, const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

template <typename Type>
void evd(const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<typename la_objects::LAMatrix<Type>::BaseType >&, la_objects::LAMatrix<Type>&);

template <typename Type>
void evd(const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<typename la_objects::LAMatrix<Type>::BaseType >&, la_objects::LAMatrix<Type>&, const unsigned int);

} // END NAMESPACE LA_OPERATIONS

namespace la_objects
{

template <typename T>
class LAMatrix: public LABaseObject<T>
{

public:

    LAMatrix<T>(const size_t _n_rows, const size_t _n_cols)
        : LABaseObject<T>(_n_rows, _n_cols)
    {}
    LAMatrix<T>()
        : LABaseObject<T>()
    {}
    LAMatrix<T>(const LAMatrix<T>& _other)
        : LABaseObject<T>(_other)
    {}

    LAMatrix<T>(const size_t _n_rows, const size_t _n_cols, const std::vector<T>& _elements)
        : LABaseObject<T>(_n_rows, _n_cols, _elements)
    {}

    LAMatrix<T>& operator=(const LAMatrix<T>& _src)
    {
        la_operations::copy_data(_src, *this);
        return *this;
    }

    LAMatrix<T>& operator+=(const LAMatrix<T>& _src)
    {
        la_operations::add(_src, *this);
        return *this;
    }

    LAMatrix<T>& operator*=(const T& _value)
    {
        (LABaseObject<T>&)(*this) *= _value;
        return *this;
    }

    template <typename Type>
    friend void la_operations::add(const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

    template <typename Type>
    friend void la_operations::add(const Type&, const la_objects::LAMatrix<Type>&, const Type&, const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

    template <typename Type>
    friend void la_operations::contract(const la_objects::LAMatrix<Type>&, char, const la_objects::LAMatrix<Type>&, char, la_objects::LAMatrix<Type>&);

    template <typename Type>
    friend void la_operations::contract(const la_objects::LAMatrix<Type>&, char, const la_objects::LAMatrix<Type>&, char, const Type&, const la_objects::LAMatrix<Type>&, const Type&, la_objects::LAMatrix<Type>&);

    template <typename Type>
    friend void kronecker(const la_objects::LAMatrix<Type>&, const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<Type>&);

    template <typename Type>
    friend void la_operations::evd(const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<typename la_objects::LAMatrix<Type>::BaseType >&, la_objects::LAMatrix<Type>&);

    template <typename Type>
    friend void la_operations::evd(const la_objects::LAMatrix<Type>&, la_objects::LAMatrix<typename la_objects::LAMatrix<Type>::BaseType >&, la_objects::LAMatrix<Type>&, const unsigned int);

    template<typename X>
    LAMatrix<T>& operator=(const la_operations::Expression<X>& _expr)
    {
        la_operations::apply(*this, ~_expr);
        return *this;
    }

    template<typename X>
     LAMatrix<T>(const la_operations::Expression<X>& _expr)
    {
        la_operations::apply(*this, ~_expr);
    }
};

} // END NAMESPACE la_objects

#endif // LA_OBJECTS