#ifndef LA_EXPRESSIONS
#define LA_EXPRESSIONS

#include <la/la_objects.h>

namespace la_operations
{

struct op_mult {};
struct op_add {};
struct op_trans {};
struct op_adj {};

// declare unary operations
template <typename T> using tM = UnaryExpression<const la_objects::LAMatrix<T>, op_trans>;
template <typename T> using aM = UnaryExpression<const la_objects::LAMatrix<T>, op_adj>;
template <typename T> tM<T> transpose(const la_objects::LAMatrix<T>& _arg) { return tM<T>(_arg); };
template <typename T> aM<T> adjoint(const la_objects::LAMatrix<T>& _arg) { return aM<T>(_arg); };

// declare binary expressions and corresponding apply functions
// c*M
template <typename T> using CM = const BinaryExpression<const T, op_mult, const la_objects::LAMatrix<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, CM<T>&);

// M+M
template <typename T> using MpM = const BinaryExpression<const la_objects::LAMatrix<T>, op_add, const la_objects::LAMatrix<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MpM<T>&);

// a*M+b*M
template <typename T> using aMpbM = const BinaryExpression<const CM<T>, op_add, const CM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, aMpbM<T>&);

// M*M
template <typename T> using MM = const BinaryExpression<const la_objects::LAMatrix<T>, op_mult, const la_objects::LAMatrix<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MM<T>&);

// M*trans(M)
template <typename T> using MtM = const BinaryExpression<const la_objects::LAMatrix<T>, op_mult, const tM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MtM<T>&);

// trans(M)*M
template <typename T> using tMM = const BinaryExpression<const tM<T>, op_mult, const la_objects::LAMatrix<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, tMM<T>&);

// M*adj(M)
template <typename T> using MaM = const BinaryExpression<const la_objects::LAMatrix<T>, op_mult, const aM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MaM<T>&);

// adj(M)*M
template <typename T> using aMM = const BinaryExpression<const aM<T>, op_mult, const la_objects::LAMatrix<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, aMM<T>&);

// A*B+c*B
template <typename T> using MMpCM = const BinaryExpression<MM<T>, op_add, CM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MMpCM<T>&);

// trans(A)*B+c*B
template <typename T> using tMMpCM = const BinaryExpression<tMM<T>, op_add, CM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, tMMpCM<T>&);

// A*trans(B)+c*B
template <typename T> using MtMpCM = const BinaryExpression<MtM<T>, op_add, CM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MtMpCM<T>&);

// adj(A)*B+c*B
template <typename T> using aMMpCM = const BinaryExpression<aMM<T>, op_add, CM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, aMMpCM<T>&);

// A*adj(B)+c*B
template <typename T> using MaMpCM = const BinaryExpression<MaM<T>, op_add, CM<T>>;
template <typename T> static void apply(la_objects::LAMatrix<T>&, MaMpCM<T>&);

/// overload *-operator to return binary expresion
template <typename LArg, typename RArg>
BinaryExpression<const LArg, op_mult, const RArg> operator*(const LArg& _larg, const RArg& _rarg)
{
    return BinaryExpression<const LArg, op_mult, const RArg>(_larg, _rarg);
}

/// overload +-operator to return binary expresion
template <typename LArg, typename RArg>
BinaryExpression<const LArg, op_add, const RArg> operator+(const LArg& _larg, const RArg& _rarg)
{
    return BinaryExpression<const LArg, op_add, const RArg>(_larg, _rarg);
}

} // END NAMESPACE la_operations

#endif // LA_EXPRESSIONS