#include <chrono>
#include <vector>
#include <numeric>

// Measures CPU time in microseconds
class CPUTimer {

private:

    std::chrono::time_point<std::chrono::steady_clock> t_start;
    std::chrono::time_point<std::chrono::steady_clock> t_end;

public:

    CPUTimer() : t_start(std::chrono::steady_clock::now()), t_end(std::chrono::steady_clock::now()) {}
    void start();
    void stop();
    double elapsed();

    template <typename F>
    double benchmark(F _func, const unsigned int _n_samples = 100, const unsigned int _n_warmup = 0) {

        for(unsigned int i = 0; i < _n_warmup; i++) {
            _func();
        }

        std::vector<double> timings(_n_samples);
        for(auto& timing : timings) {
            this->start();
            _func();
            this->stop();
            timing = this->elapsed();
        }
        return std::accumulate(timings.begin(), timings.end(), 0) / _n_samples;
    };

};
