function var = twoSiteVariance_Ex(M,Hs)
% < Description >
%
% var = twoSiteVariance_Ex(M,Hs)
%
% function to compute the two-site variance
% For reference, see C. Hubig et al., PRB 97, 045125 (2018)
%
% < Input >
% M  : [1 x N cell array] MPS of which the two-site variance is computed.
% Hs : [1 x N cell array] Matrix product operator (MPO) of the Hamiltonian.
%       Each Hs{n} acts on site n, and is rank-4 tensor. The order of legs
%       of Hs{n} is left-bottom-right-top, where bottom (top) leg is to be
%       contracted with bra (ket) tensor. The length N of Hs, i.e.,
%       numel(Hs), determines the chain length.
%
% < Output >
% var : [numeric] The two-site variance of M.
%
% Written by A.Gleis (May 25,2021)

if numel(M) ~= numel(Hs)
    error('The lengths of M and Hs do not match!');
end

% length of MPS
N = numel(M);

% first, calculate L_{i}*W_{i}*A_{i}*F_{i}^{\dagger}
XF = cell(1,N);
M = canonForm(M,N); % left-normalize
L = [];
for itN = 1:N
    % determine F:
    [F,~] = qr(reshape(M{itN},[size(M{itN},1)*size(M{itN},2),size(M{itN},3)])); % use QR decomposition to generate F
    F = F(:,(size(M{itN},3)+1):end); % F(:,1:size(M{itN},3)) is M{itN}
    F = reshape(F,[size(M{itN},1),size(M{itN},2),size(F,2)]);
    if ~isempty(F)
        XF{itN} = updateLeft(L,3,M{itN},Hs{itN},4,F);
    else
        XF{itN} = [];
    end
    L = updateLeft(L,3,M{itN},Hs{itN},4,M{itN});
end

% sweep right -> left to generate R_{i} and Y_{i}
R = getIdentity(M{end},3,Hs{end},3);
HP2 = cell(1,N-1);
HP1 = cell(1,N);
UM = [];
SM = [];
for itN = N:-1:1
    if ~isempty(XF{itN})
        if ~isempty(UM)
            XFtmp = contract(UM*diag(SM),2,1,XF{itN},3,1);
        else
            XFtmp = XF{itN};
        end
        HP1{itN} = contract(XFtmp,3,[1 2],R,3,[1 2]);
    else
        HP1{itN} = [];
    end
   % right-normalize M{itN}:
   [UM,SM,M{itN}] = svdTr(M{itN},3,1,[],[]);
   if itN > 1
       M{itN-1} = contract(M{itN-1},3,3,UM*diag(SM),2,1);
   end
   % determine G
   % % % TODO - Exercise 2: % % %
   % determine G analogous to F (see Eq.(14) and (15) in the reference)

   
   % % % TODO - end of Exercise 2 % % %
   if ~isempty(G)
       % % % TODO - Exercise 2: % % %
       % compute Y*G as in Fig.4 in the reference

       
       % % % TODO - end of Exercise 2 % % %
       if itN > 1
           if ~isempty(XF{itN-1})
               HP2{itN-1} = contract(XF{itN-1},3,[1 2],YG,3,[1 2]);
           else
               HP2{itN-1} = [];
           end
       end
   else
       if itN > 1
           HP2{itN-1} = [];
       end
   end
           
   R = updateLeft(R,3,permute(M{itN},[3 2 1]),...
       permute(Hs{itN},[3 2 1 4]),4,permute(M{itN},[3 2 1]));
   
end

var = 0;
% % % TODO - Exercise 2: % % %
% compute the two-site variance via HP1 and HP2


% % % TODO - end of Exercise 2 % % %

end


