%% [Tutorial T10.3] DMRG: error estimation (optional)
% Author: Andreas Gleis
%% Exercise (a): Complete the function twoSiteVariance|_Ex.m|
% There is a function twoSiteVariance|_Ex.m| which is placed in the same subdirectory 
% together with this tutorial material. This function partially implements the 
% calculation of the two-site variance as an error meassure. *Complete the parts 
% which are enclosed by the comments |TODO - Exercise 2.*|
%% 
% 
%% Heisenberg chain: error estimation
% To test twoSiteVariance|_Ex.m| we consider a Heisenberg spin chain and calculate 
% its ground-state. Its Hamiltonian is given by
% 
% $$H = \sum_{l=1}^{N-1} \vec{S}_{l}\vec{S}_{l+1} \, .$$
% 
% In the following, we will compare the two-site variance of the optimized GS 
% obtained by DMRG3S and two-site DMRG for different bond dimensions.

clear

% system parameter
J = 1; % coupling strength
N = 40; % number of sites in a chain

% DMRG parameter
Nsweep = 10; % number of pairs of left+right sweeps

% magnitude of local spin
s = 1/2;
% Local operators
[S,I] = getLocalSpace('Spin',s);
%% 
% We set up the MPO of the Heisenberg chain as given in the lecture:

% % MPO formulation of Hamiltonian
% Hamiltonian tensor for each chain site
Hloc = cell(5,5);
Hloc(:) = {zeros(size(I))};
Hloc{1,1} = I;
Hloc{2,1} = squeeze(S(:,1,:));
Hloc{3,1} = squeeze(S(:,2,:));
Hloc{4,1} = squeeze(S(:,3,:));
Hloc{end,2} = J*(Hloc{2,1}');
Hloc{end,3} = J*(Hloc{3,1}');
Hloc{end,4} = J*(Hloc{4,1}');
Hloc{end,end} = I;
Hloc = cell2mat(reshape(Hloc,[1 1 size(Hloc,1) size(Hloc,2)]));
Hloc = permute(Hloc,[3 1 4 2]); % leg order: left-bottom-right-top

% full chain
Hs = cell(1,N);
Hs(:) = {Hloc};
Hs{1} = Hs{1}(end,:,:,:); % choose the last components of the left leg
Hs{end} = Hs{end}(:,:,1,:); % choose the first components of the right leg
%% 
% Run the DMRG for different bond dimensions.

Nkeeps = [5,10,20,40,80,160]; % bond dimensions
var_2site = zeros(1,numel(Nkeeps));
var_3S = zeros(1,numel(Nkeeps));
for itK = 1:numel(Nkeeps)
    Nkeep = Nkeeps(itK);
    
    % first 2-site DMRG:
    [MGS_2site,~,~] = DMRG_2site(Hs,Nkeep,Nsweep);
    var_2site(itK) = twoSiteVariance_Ex(MGS_2site,Hs);
    
    % DMRG3S
    [MGS_3S,~,~] = DMRG_3S(Hs,Nkeep,Nsweep);
    var_3S(itK) = twoSiteVariance_Ex(MGS_3S,Hs);
end
%% 
% Plot how the two-site variance decreases with the bond dimension:

    figure;
    semilogy(Nkeeps,var_2site,'-x','LineWidth',1);
    hold on;
    semilogy(Nkeeps,var_3S,'--o','LineWidth',1);
    set(gca,'FontSize',13,'LineWidth',1);
    xlim([0 max(Nkeeps)]);
    grid on;
    legend({'2-site DMRG','DMRG3S'},'FontSize',13)
    xlabel('N_{keep}');
    ylabel('two-site variance');
    hold off;
%% 
% As expected, the variance decreases with $N_{\mathrm{keep}}$. Two-site DMRG 
% and DMRG3S yield almost identical variances. Note however that DMRG3S is only 
% marginally faster for $s=1/2$ than 2-site DMRG. This is because of the small 
% physical dimension $d=2$. If $s$ is increased, $d$ increases and the DMRG3S 
% eventually becomes faster. However, calculations also become quite a bit heavier. 
% But if your computer is able to handle it, give larger $s$ a try!