function [out] = XY_lnZ(nsite_, beta_)
% compute the log of the partition function (Z) of the 1D XY model
% < input >
% nsite_: # of sites
% beta_: the inverse temperature

% < output >
% out: a scaler for ln(Z)
%
% ref: 10.1103/PhysRevX.8.031082, Appendix F

  out = 0;
  for kk = 1 : nsite_
    ek = -beta_*cos(kk*pi/(nsite_+1));
    if ek  < 0 
      out = out + log1p(exp(ek));
    else
      out = out + ek + log1p(exp(-ek));
    end 
  end 
end
