function [out]= TRACE(mpo_)
% compute Tr(MPO^{\dagger} \times MPO)
% < input >
% mpo_: a matrix product operator; index ordering: left-down-up-right
%
% < output >
% out: a scaler

  nsite = numel(mpo_);
  out = 1;
  for isite = 1 : nsite
    tmp = contract(out, 2, [1], conj(mpo_{isite}), 4, [1]);
    out = contract(tmp, 4, [1:3], mpo_{isite}, 4, [1:3]);
  end
end
