function [mpo]= MPS2MPO(mps_)
% reshape an MPS to an MPO
% < input >
% mps_: a matrix product state; index ordering: left-down-right
%
% < output >
% mpo: a matrix product operator; index ordering: left-down-up-right

  nsite = numel(mps_);
  mpo = cell(nsite,1);
  for ii = 1 : nsite
    [sM1,sM2,sM3] = size(mps_{ii});
    mpo{ii} = reshape(mps_{ii}, [sM1, sqrt(sM2), sqrt(sM2), sM3]);
  end
end
