function [mps]= MPO2MPS(mpo_)
% reshape an MPO to an MPS
% < input >
% mpo_: a matrix product operator; index ordering: left-down-up-right
%
% < output >
% mps: a matrix product state; index ordering: left-down-right

  nsite = numel(mpo_);
  mps = cell(nsite,1);
  for ii = 1 : nsite
    [sM1,sM2,sM3,sM4] = size(mpo_{ii});
    mps{ii} = reshape(mpo_{ii}, [sM1,sM2*sM3,sM4]);
  end
end
