function [mpo, fac] = ITE_ex(mpo, gate_, dkeep_)
% perfrom the imaginary time evolution on the lower legs of an MPO
% < input >
% mpo: a matrix product operator; index ordering: left-dwon-up-right
% gate_: a rank-4 2-site operator; index ordering: (lower left)-(upper left)-(lower right)-(upper right)
% dkeep_: the maximum bond dimension for left & right indices
%
% < output >
% mpo: a right canonicalized matrix product operator
% fac: a scalar due to the canonicalization

  fac = 0;
  nsite = numel(mpo);

  % apply the gate to the mpo on all bonds with the ordering: 
  % 1-2, 3-4, ..., (N-1)-N, (N-2)-(N-1), ..., 4-5, 2-3
  idx = [1:2:(nsite-2*mod(nsite,2)), (nsite-2*mod(nsite+1,2)):-2:1]; 
  for ii = 1 : nsite-1
     isite = idx(ii);
     % TODO: Exercise (a) begins
     % compute the rank-6 tensor [wfn] = [gate_]*[mpo(isite)]*[mpo(isite-1)]
     % index ordering of [wfn]:
     %     (3)(5) 
     %      |  |
     % (1)--+--+--(6)
     %      |  |
     %     (2)(4)
     % TODO: Exercise (a) ends     

     if mod(isite,2) % if odd, left->right
       if (isite ~= (nsite-1)) % shift the canonical center from (isite) to (isite+2)
         [mpo{isite},s1,v1]  = svdTr(wfn, 6, [1,2,3], dkeep_, 1E-13);
         
         sv1 = contract(diag(s1), 2, [2], v1, 4, [1]);
         [mpo{isite+1},s2,v2] = svdTr(sv1, 4, [1,2,3], dkeep_, 1E-13);
         
         sv2 = contract(diag(s2), 2, [2], v2, 2, [1]);
         mpo{isite+2} = contract(sv2, 2, [2], mpo{isite+2}, 4, [1]);
         
       else % at the right end, fix the canonical center at (isite)
         [u1,s1,mpo{isite+1}]  = svdTr(wfn, 6, [1,2,3], dkeep_, 1E-13);
         mpo{isite} = contract(u1, 4, [4], diag(s1), 2, [1]);
       end
       
     else % if even, right->left
       % shift the canonical center from (isite+1) to (isite-1)
       [u1,s1,mpo{isite+1}]  = svdTr(wfn, 6, [1,2,3], dkeep_, 1E-13);
       
       us1 = contract(u1, 4, [4], diag(s1), 2, [1]);
       [u2,s2,mpo{isite}]  = svdTr(us1, 4, [1], dkeep_, 1E-13);
       
       us2 = contract(u2, 2, [2], diag(s2), 2, [1]);
       mpo{isite-1} = contract(mpo{isite-1}, 4, [4], us2, 2, [1]);
       if (isite==2) % at the left end
         [u2,s2,mpo{isite-1}]  = svdTr(mpo{isite-1}, 4, [1], dkeep_, 1E-13);
         fac = contract(u2, 2, [2], diag(s2), 2, [1]);
       end
     end
  end
end
