function [mps,es,dw] = MPOMPS_ex(orb_,chi_)
% MPO-MPS approach to construct parton wavefunctions
% Written by HHT (2019)
% Edited by JWL (2021)
%
% < input >
% orb_: # single-particle orbitals % d^\dag_{m} = \sum_j orb_{m,j} c^\dag_{j}
% chi_: the maximum bond dimension of MPS
%
% < output >
% mps: left canonical MPS
% es: half-chain entanglement entropies during MPO-MPS operations
% dw: truncation errors during MPO-MPS operations
%
% Ref.1 10.1103/PhysRevLett.124.246401

norb = 2*size(orb_,1); % # of single particles; 2 accounts for two flavors of spins
nsite = size(orb_,2); % # of sites
% generate the single particle orbital coefficients for the Jordan--Wigner spin chain of 2*nsite sites
% d^\dag_{m} = \sum_\ell orb{m,\ell} c^\dagger_{\ell} [see the description at page 2 in Ref.1]
orb = zeros(norb,2*nsite);
orb(1:2:norb,1:2:2*nsite) = orb_;
orb(2:2:norb,2:2:2*nsite) = orb_;

% define vacuum MPS [index order: (left, down, right)]
mps = cell(1,nsite);
vac = zeros(1,3,1);
vac(:,3,:) = 1;
for counter = 1:nsite
  mps{counter} = vac;
end

% build tensors for constructing MPO [index order: (left, down, right, up)]
[S,I] = getLocalSpace('Spin',1/2);
s1 = sqrt(2)*squeeze(S(:,1,:)); %sigma^+
s3 = 2*squeeze(S(:,3,:)); %sigma^z
t1 = zeros(2,2,2,2);
t1(1,:,1,:) = s3;
t1(2,:,2,:) = I;

% generate MPS by MPO-MPS procedure
fprintf('# of applied MPOs | Entanglement Entroy | Trucation Error\n')
es = []; dw = [];
for orbital = 1:norb
  % TODO: Exercise (a) begins
  % build the D=2 MPO associated with current orbital [see eq.(2) in Ref.1]
  % step1.a build mpoJW: the MPO on a 2*nsite spin chai via the Jordan--Wigner(JW) transformation [see eq.(S1) in Ref.1]
  mpoJW = repmat({t1},[1,2*nsite]);
  for isite = 1:(2*nsite)
    mpoJW{isite}(??,:,??,:) = orb(??,??)*s1; % what are the values for ??, please fill in something
  end
  % step1.b apply the boundary tensors [0,1] on the virtual bonds at the left end of the mpo
  % fill in something %
  % step1.c apply the boundary tensors [1;0] on the virtual bonds at the right end of the mpo
  % fill in something %
  % TODO: Exercise (a) ends

  % step2 construct spinful MPO by fusing spin-up and spin-down JW spins on the same site together from mpoJW
  mpo = cell(nsite,1);
  for isite = 1:nsite
    % combine phical indices on sites [2*isite-1] and [2*isite] to build an MPO with length nsite
    tmp = contract(mpoJW{2*isite-1},4,3,mpoJW{2*isite},4,1,[1,2,4,5,3,6]);
    mpo{isite} = reshape(tmp,[size(tmp,1),size(tmp,2)*size(tmp,3),size(tmp,4),size(tmp,5)*size(tmp,6)]);
    % apply partial Gutzwiller projection to MPO by removing dobuly occupied states
    mpo{isite}(:,1,:,:) = []; 
    mpo{isite}(:,:,:,1) = []; 
  end 

  % apply MPO to MPS
  for isite = 1:nsite
    tmp = contract(mps{isite},3,2,mpo{isite},4,4,[1,3,4,2,5]);
    mps{isite} = reshape(tmp,[size(tmp,1)*size(tmp,2), size(tmp,3),size(tmp,4)*size(tmp,5)]);
  end 

  % compress MPS & compute half-chain entanglement entropy
  if mod(orbital,2) == 0
    [mps] = canonForm(mps,0);
    [mps,~,err] = canonForm(mps,nsite,chi_);
    [~,sv] = canonForm(mps,nsite/2);
    es(end+1) = -sum(2*sv.^2.*log2(sv));
    dw(end+1) = max(err);
    fprintf('%17d | %19.8f | %15.3e \n',orbital, es(end), dw(end));
  end          
end

% apply full Gutzwiller projection by removing empty states
for isite = 1:nsite
  mps{isite}(:,3,:) = [];
end
% left canonicalize
[mps] = canonForm(mps,nsite);
end
