function [orb0,orb1,orb2] = HS1D_ex(nsite)
% single-particle orbitals of the 1D Haldane-Shastry model
% < input >
% nsite: # of sites
% < output >
% orb0: single-particle orbitals
% d^\dag_{m} = \sum_j orb_{m,j} c^\dag_{j}
%
% orb1: maximally localized Wannier orbitals
% orb2: maximally localized Wannier orbitals + left-meet-right strategy 
% Ref.1 10.1103/PhysRevLett.124.246401

orb0 = zeros(nsite/2,nsite);
phase = (floor(nsite/4) : -1 : floor(nsite/4)-nsite/2+1)*(2*pi/nsite);
for ii = 1:nsite
  orb0(:,ii) = exp(-1i*ii*phase)/sqrt(nsite);
end

orb1 = []; orb2 = [];
% TODO: Exercise (b) begins
% 2a. maximally localized Wannier orbitals [see eq.(3,4) in Ref.1]
position = orb0*diag(1:nsite)*(orb0)';
position = (position+position')/2; % this is the position operator 
% fill in something to obtain orb1
% 2b. maximally localized Wannier orbitals + left-meet-right strategy [see descriptions below eq.(3) in Ref.1]
% fill in something to obtain orb2
% TODO: Exercise (b) ends
end
